//=============================================================================
// WaitForVideoEndFix.js
//=============================================================================
 
/*:
 * @plugindesc Fixes the bug where the event doesn't wait for the video to end to continue its instructions
 * @author Orcomarcio
 */

var unblockedvideo = false;
var unblockedvideostarted = false;

Game_Interpreter.prototype._isVideoStarted = false;
Game_Interpreter.prototype.updateWaitMode = function() {
    var waiting = false;
    
    if (!unblockedvideostarted && unblockedvideo && Graphics.isVideoPlaying()){
        unblockedvideostarted = true   
    }
    else if(unblockedvideostarted){
        if (Input.isPressed("escape"))
        {
            Graphics._stopVideo();
        }

        if (!Graphics.isVideoPlaying())
        {
            Graphics._stopVideo();
            unblockedvideo = false;
            unblockedvideostarted = false
        }
    }
    
    


    switch (this._waitMode) {
    case 'message':
        waiting = $gameMessage.isBusy();
        break;
    case 'transfer':
        waiting = $gamePlayer.isTransferring();
        break;
    case 'scroll':
        waiting = $gameMap.isScrolling();
        break;
    case 'route':
        waiting = this._character.isMoveRouteForcing();
        break;
    case 'animation':
        waiting = this._character.isAnimationPlaying();
        break;
    case 'balloon':
        waiting = this._character.isBalloonPlaying();
        break;
    case 'gather':
        waiting = $gamePlayer.areFollowersGathering();
        break;
    case 'action':
        waiting = BattleManager.isActionForced();
        break;
    case 'video':
        if (Input.isPressed("escape"))
        {
            Graphics._stopVideo();
        }
		if (this._isVideoStarted && !Graphics.isVideoPlaying()) {
			waiting = false;
			this._isVideoStarted = false;
			Graphics._readjustAudio();
		}
		else {
			waiting = true;
			if (Graphics.isVideoPlaying())
				this._isVideoStarted = true;
		}
        break;
    case 'image':
        waiting = !ImageManager.isReady();
        break;
    }
    if (!waiting) {
        this._waitMode = '';
    }
    return waiting;
};

var aliasPluginCommand = Game_Interpreter.prototype.pluginCommand;

Game_Interpreter.prototype.pluginCommand = function(command, args){

	aliasPluginCommand.call(this, command, args);
	if(command === "playMovieBlocked"){
		if (!$gameMessage.isBusy()) {
	        var name = args[0];
	        if (name.length > 0) {
	            var ext = this.videoFileExt();
	            Graphics.playVideo('movies/' + name + ext);
	            this.setWaitMode('video');
	        }
	        this._index++;
	    }
	}
	if(command === "playMovieUnblocked"){
		if (!$gameMessage.isBusy()) {
	        var name = args[0];
	        if (name.length > 0) {
	            var ext = this.videoFileExt();
	            Graphics.playVideo('movies/' + name + ext);
	            // this.setWaitMode('videounblocked');
                unblockedvideo = true;
	        }
	        this._index++;
	    }
	}
}